﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using Microsoft.Reporting.WebForms;
using BMS.Web.App_GlobalResource;
using BMS.Facade;
using BMS.Utils;
using BMS.Web.Reporting;
using System.Web.UI.WebControls;
using BMS.Web.Controllers.Shared;

namespace BMS.Web.Reports
{
    public partial class EvacuationPatientReportViewer : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {


                facilityHomeLink.Text = Strings.BMS_Home;
                iconsHomeLink.Text = Strings.IconLegend;
                informationHomeLink.Text = Strings.Information;
                homeLink.Text = BMS.Web.App_GlobalResource.Strings.ReturnToMainPage;
                homeLink.NavigateUrl = "~";

                if (Request == null || Request.QueryString == null || Request.QueryString.Count == 0)
                    return;

                String token = Request.QueryString[0];
                if (String.IsNullOrEmpty(token))
                    return;

                ReportUtil reportUtil = ReportUtil.Decrypt(token);
                ReportViewerControl.ServerReport.ReportServerUrl = new Uri(reportUtil.ReportServerUrl);
                if (this.IsPostBack)
                {
                    ScriptManager.RegisterClientScriptBlock(this, this.GetType(), "key", "ResizeForm();", true);
                }
                else
                {

                    string returnUrl = reportUtil.Parameters[Constants.REP_GENERAL_RETURN_PATH];
                    string returnText = System.Web.HttpContext.Current.Server.UrlDecode(reportUtil.Parameters[Constants.REP_GENERAL_RETURN_TEXT]);
                    string reportTitle = System.Web.HttpContext.Current.Server.UrlDecode(reportUtil.Parameters[Constants.REPORT_TITLE]);
                    string title = System.Web.HttpContext.Current.Server.UrlDecode(reportUtil.Parameters[Constants.REP_PAGE_TITLE]);

                    if (!string.IsNullOrEmpty(title))
                        pageTitle.Value = title;

                    if (!string.IsNullOrEmpty(returnUrl))
                        homeLink.NavigateUrl = returnUrl;
                    else
                        homeLink.Visible = false;
                    if (!string.IsNullOrEmpty(returnText))
                        homeLink.Text = returnText;
                    else
                        homeLink.Visible = false;
                    if (!string.IsNullOrEmpty(reportTitle))
                    {
                        AntiXssEncoder xss = new AntiXssEncoder();
                        reportName.InnerText = xss.Decode(reportTitle);                        
                    }

                    ReportViewerControl.ServerReport.ReportPath = reportUtil.ReportPath;
                    ReportViewerControl.ServerReport.ReportServerCredentials =
                        (
                        String.IsNullOrEmpty(reportUtil.Domain) ?
                        new CustomReportCredentials(reportUtil.UserName, reportUtil.Password) :
                        new CustomReportCredentials(reportUtil.UserName, reportUtil.Password, reportUtil.Domain)
                    );

                    List<ReportParameter> param = new List<ReportParameter>();

                    ReportParameterInfoCollection coll = null;

                    try
                    {
                        coll = ReportViewerControl.ServerReport.GetParameters();
                        if (coll.FirstOrDefault(p => string.Equals(p.Name, Strings.UserNameID, StringComparison.InvariantCultureIgnoreCase)) != null)
                            param.Add(new ReportParameter(Strings.UserNameID, reportUtil.UserId, false));

                        foreach (var paramName in reportUtil.Parameters.Keys)
                            if (coll.FirstOrDefault(p => string.Equals(p.Name, paramName, StringComparison.InvariantCultureIgnoreCase)) != null)
                                param.Add(new ReportParameter(paramName, reportUtil.Parameters[paramName], true));

                        //adds all the parameter values passed through the query string, excepting UserID and ApplicationURL that are treated separately above and below.
                        foreach (ReportParameterInfo paramName in coll)
                            if (coll.FirstOrDefault(p => string.Equals(p.Name, paramName.Name, StringComparison.InvariantCultureIgnoreCase)) != null)
                            {
                                if (Request.QueryString[paramName.Name] != null)
                                    param.Add(new ReportParameter(paramName.Name, Request.QueryString[paramName.Name], true));
                            }

                        if (coll.FirstOrDefault(p => string.Equals(p.Name, Strings.ApplicationURL, StringComparison.InvariantCultureIgnoreCase)) != null)
                        {
                            string url = HttpContext.Current.Request.Url.ToString();
                            int rpt = url.IndexOf("/" + Strings.ReportsFolder);
                            if (rpt > -1)
                            {
                                url = url.Substring(0, rpt);
                                param.Add(new ReportParameter(Strings.ApplicationURL, url, false));
                            }
                        }

                        ReportViewerControl.ServerReport.SetParameters(param);
                        //ReportViewerControl.Height = 1000;
                        //ReportViewerControl.ZoomMode = ZoomMode.Percent;
                        //ReportViewerControl.ZoomPercent = 225;

                    }
                    catch (Microsoft.Reporting.WebForms.ReportServerException rsException)
                    {
                        OnError(rsException.ErrorCode + "\t" + rsException.Message);
                    }

                }

            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        protected void OnError(String message)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                Session[Constants.REPORTS_ERROR_MESSAGE_SESSION_KEY] = message;
                Response.Redirect("ReportError.aspx");
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        protected void ReportViewerControl_ReportError(object sender, ReportErrorEventArgs e)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (e.Exception != null &&
                    e.Exception.InnerException != null &&
                    e.Exception.InnerException.InnerException != null)
                {
                    e.Handled = true;
                    OnError(e.Exception.InnerException.InnerException.Message);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        protected void Viewer_SubmittingParameters(object sender, ReportParametersEventArgs e)
        {
            String token = Request.QueryString[0];
            if (String.IsNullOrEmpty(token))
                return;

            ReportUtil reportUtil = ReportUtil.Decrypt(token);
            ReportViewerControl.ServerReport.ReportServerUrl = new Uri(reportUtil.ReportServerUrl);
            ReportParameterInfoCollection paramters = null;
            paramters = ReportViewerControl.ServerReport.GetParameters();
            ReportParameterInfo selectedDivision = paramters.FirstOrDefault(p => string.Equals(p.Name, Strings.DivisionId, StringComparison.InvariantCultureIgnoreCase));
            ReportParameterInfo facilityCode = paramters.FirstOrDefault(p => string.Equals(p.Name, Strings.FacilityCode, StringComparison.InvariantCultureIgnoreCase));
            string selectedDivisionId = e.Parameters[0].Values[0];
            string selectedDivisionName = selectedDivision.ValidValues.Where(a => a.Value.Equals(selectedDivisionId, StringComparison.InvariantCultureIgnoreCase)).Select(a => a.Label).FirstOrDefault();
            string selectedReportType = e.Parameters[1].Values[0].ToString();
            string reportTitle = string.Empty;

            reportTitle = ConfigureReportDisplayParams(reportUtil, facilityCode, selectedDivisionName, reportTitle, selectedReportType);

            reportUtil.Parameters[Constants.REP_GENERAL_DEFAULT_DIVISION_ID] = selectedDivisionId;
            reportUtil.Parameters[Constants.REP_GENERAL_DEFAULT_DIVISION_NAME] = selectedDivisionName;
            reportUtil.Parameters[Constants.REPORT_TITLE] = reportTitle;
            string encryptToken = ReportUtil.Encrypt(reportUtil);

            Response.Redirect("EvacuationPatientReportViewer.aspx?" + encryptToken);
        }

        public static string ConfigureReportDisplayParams(ReportUtil reportUtil, ReportParameterInfo facilityCode, string selectedDivisionName, string reportTitle, string reportType)
        {
            reportTitle = string.Format("{0} {1} {2} {3}", facilityCode.Values[0], reportType, Strings.ReportFor, selectedDivisionName);
            reportUtil.Parameters[Constants.REP_GENERAL_IS_ROSTER_REPORT] = reportType == Constants.ROSTER ? "True" : "False";
            reportUtil.Parameters[Constants.REP_GENERAL_IS_REGULATE_REPORT] = reportType == Constants.REGULATE ? "True" : "False";
            reportUtil.Parameters[Constants.REP_GENERAL_IS_MANIFEST_REPORT] = reportType == Constants.MANIFEST ? "True" : "False";
            reportUtil.Parameters[Constants.REP_GENERAL_IS_TRANSFER_REPORT] = reportType == Constants.TRANSFER ? "True" : "False";
            reportUtil.Parameters[Constants.REP_GENERAL_REPORT_TYPE] = reportType;
            return reportTitle;
        }
    }
}